#!/usr/bin/perl

#scl file generator script

#February 15 2008 v01 CRADU

#usage sclgen.pl [ INPUT_FILE ]
#	if no INPUT FILE is provided the default sclgen.input will be used
#	if no sclgen.input is found in root dir than the default values wille used

my $SCLGEN_VERSION = "v01";
my $ROWSTART = 20;
my $COLSTART = 20;

#defaul hard coded input parameters
$row_height = 1;
$cell_width = 1;
$cell_spacing = 0;
$rows_num = 10;
$cells_in_row = 10;

#default input file name 
$DEFAULT_INPUT_FILE_NAME = "sclgen.input";

$input_file_name = $ARGV[0];

if ( !defined($input_file_name) ) {
  print "\nNo input file was provided; using $DEFAULT_INPUT_FILE_NAME !\n";
  $input_file_name = $DEFAULT_INPUT_FILE_NAME;
}

#parse input file 
my $line;
if ( open INPUTFILE, "<$input_file_name"  ) {#input file succesfully opened
  while( defined($line = <INPUTFILE>) ) {
    $line =~ s/^\s+//; #remove front/end white spaces
    $line =~s/\+$//;
    @words = split(/\s+/,$line);
    $num_words = @words;
    if( !defined($words[0]) || $words[0] eq "#" || $num_words < 1 ) {
      next; #skip comment or blamk lines
    }
    
    if( $words[0] eq "ROW_HEIGHT" ) {
      defined $words[1] || die "ERROR: invalid argument for ROW_HEIGHT\n";
      print "found row height argument : $words[1]\n";
      $row_height = $words[1];
      next;
    }
    if( $words[0] eq "CELL_WIDTH" ) {
      defined $words[1] || die "ERROR: invalid argument for CELL_WIDTH\n";
      print "found cell width argument : $words[1]\n";
      $cell_width = $words[1];
      next;
    }
    if( $words[0] eq "CELL_SPACING" ) {
      defined $words[1] || die "ERROR: invalid argument for CELL_SPACING\n";
      print "found cell spacing argument : $words[1]\n";
      $cell_spacing = $words[1];
      next;    
    }
    if( $words[0] eq "ROW_NUM" ) {
      defined $words[1] || die "ERROR: invalid argument for ROW_NUM\n";
      print "found rows number argument : $words[1]\n";
      $rows_num = $words[1];
      next;
    }
    if( $words[0] eq "CELL_IN_ROW" ) {
      defined $words[1] || die "ERROR: invalid argument for CELL_IN_ROW\n";
      print "found cells in row argument : $words[1]\n";
      $cells_in_row = $words[1];
      next;
    }
    
    #invalid line ? ignored
    print "IGNORE input file line :\n$line\n";
  }
  close INPUTFILE ;
}

print "Arguments set :
row height   : $row_height
cell width   : $cell_width
cell spacing : $cell_spacing
rows number  : $rows_num
cells in row : $cells_in_row\n" ;

####################################################################
# Generate output .scl file
####################################################################
my $DEFAULT_OUTPUTFILE_NAME = "output.scl";
print "Generate $DEFAULT_OUTPUTFILE_NAME file ...\n";

open ( OUTFILE, ">$DEFAULT_OUTPUTFILE_NAME" ) 
    || die "ERROR : Cannot create output file. exit...\n";
  

#print the header
print OUTFILE "UCLA scl 1.0\n";
print OUTFILE "# Created\t:\t\t\n";
print OUTFILE "# USER\t\t:\t\t SclGen.pl $SCLGEN_VERSION\n";

#print number of rows
print OUTFILE "\nNumRows : $rows_num\n\n";

#print the core rows
my $y_coord = $ROWSTART; #y row coords start from 0
for( $i = 0 ; $i < $rows_num ; $i++ ){
  my $row_coord = $y_coord + ( $i * $row_height ) ;

  print OUTFILE "CoreRow Horizontal\n";
  print OUTFILE " Coordinate   :   $row_coord\n";
  print OUTFILE " Height       :   $row_height\n";
  print OUTFILE " Sitewidth    :   $cell_width\n";
  print OUTFILE " Sitespacing  :   $cell_spacing\n";
  print OUTFILE " Siteorient   :   1\n";		#constant 1
  print OUTFILE " Sitesymmetry :   1\n";	#constant 1
  print OUTFILE " SubrowOrigin :   $COLSTART\tNumSites  :  $cells_in_row\n"; #x row coord is 0
  print OUTFILE "End\n";
}

close OUTFILE ;

print "Done.\n"
