#!/usr/bin/perl

#region legality checker script

#June 05 2008 v01 CRADU

#usage regions_legality_check.pl -props <prop file> -regions <regions file> \
#                                -pl <pl file>

my $REG_CHECK_VERSION = "v01";
sub eprint
{
    print       "@_";
    print EFILE "@_";
}

sub lprint
{
    print EFILE "@_";
}

#open error log file
unless (open (EFILE, ">reg_legality.log")) { 
    die  "unable to create reg_legality.log file\n"; 
}

#parse input arguments
my $prop_file_name;
my $regions_file_name;
my $pl_file_name;
my $prop_class_name_flag;
my $node_name_flag;

#data structure for storing props data
my %prop_class_hash;
my $current_prop_class;
my %nodes_hash;
my $current_node_hash;
#data structure for storing pl data
my %pl_hash;
#data structure for storing regions data
my %regions_hash;
my $current_regions_hash;
my $regions_top_inst;
my %unique_regions_hash;
my $unique_regions_id = 0;
#data structure for processing nodes
my @region_que;
my $legal_site_found = 0;
#error count
my $error_count = 0;


#6 (six) arguments are required ( including argument names ) CHECK
if( @ARGV != 6 ) {
    my $arg_c = @ARGV;
    print "ERROR : Invalid number of arguments $arg_c\n";
    &print_usage();
    exit(0);
}

#read argument list
my $argc_count = 0;
while($argc_count < 6){
    if( $ARGV[$argc_count] eq "-props" ){
	$argc_count++;
	$prop_file_name = $ARGV[$argc_count];
    }elsif($ARGV[$argc_count] eq "-regions" ){
	$argc_count++;
	$regions_file_name = $ARGV[$argc_count];
    }elsif($ARGV[$argc_count] eq "-pl" ){
	$argc_count++;
	$pl_file_name = $ARGV[$argc_count];
    }else{
	print "ERROR : Invalid argument name %s\n",$ARGV[$argc_count];
	&print_usage();
     	exit(0);
    }
    $argc_count++;
}

#check if all file names were specified /maybe specified twice ?
if( !defined($prop_file_name)){
    print "ERROR : No props file name was specified\n";
    &print_usage();
    exit(0);
}
if( !defined($regions_file_name)){
    print "ERROR : No regions file name was specified\n";
    &print_usage();
    exit(0);
}
if( !defined($pl_file_name)){
    print "ERROR : No pl file name was specified\n";
    &print_usage();
    exit(0);
}

#parse props file 
unless ( &process_props_file() == 1 ){
    print "ERROR : parsing props file failed\n";
    my_exit();#errors encountered
}

#parse pl file 
unless ( &process_pl_file() == 1 ){
    print "ERROR : parsing pl file failed\n";
    my_exit();#errors encountered
}

#parse regions file 
unless ( &process_regions_file() == 1 ){
    print "ERROR : parsing regions file failed\n";
    my_exit();#errors encountered
}

#&dump_regions_db();#debug only
&compute_reagions_bbox(${$regions_top_inst}{"type"});
&uniquefy_regions_areas($regions_top_inst);
#&dump_regions_db();#debug only 
&process_nodes();
#&dump_regions_db();#debug only 
&check_design_colors_number($regions_top_inst);
eprint "Error Count: $error_count\n";
#close log file
close EFILE;

####################################
# process input pl file
# return 0 if errors occured; 1 if OK
####################################
sub process_pl_file
{

  unless ( open (CFILE, "<$pl_file_name") ) {
    print       "unable to open $pl_file_name file\n";
    print EFILE "unable to open $pl_file_name file\n";
    return 0;
  }


  my $line;
  my @words;


  while ( defined($line = <CFILE>)) {
    @words = get_words_list($line);  
    
    #ignore empty or coments or first header ( UCLA pl ver) lines
    if ( !@words || $words[0] eq "#" || $words[0] eq "UCLA" ) {
      next;
    }
    
    if( exists $pl_hash{$words[0]} ){
	print "ERROR : node $words[0] found twice in pl file\n";
	return 0;
    }
    
    if(!defined($words[1]) || !defined($words[2]) ){
	print "ERROR : Invlid pl file line $line\n";
	return 0;
    }
    
    my %temp_pl_hash_node = ("x_coord" => $words[1],
                            "y_coord" => $words[2]);  
    $pl_hash{$words[0]} = \%temp_pl_hash_node;  
  }
  close CFILE;
  return 1;
}

####################################
# process input config file
# return 0 if errors occured; 1 if OK
####################################
sub process_props_file
{

  unless ( open (CFILE, "<$prop_file_name") ) {
    print       "unable to open $prop_file_name file\n";
    print EFILE "unable to open $prop_file_name file\n";
    return 0;
  }

  my $line;
  my @words;
  my $props_number;
  my $PROP_SECTION;#store the file section : 0- props class; 1- nodes list
  my $STATE = 0;
# possible states 
# 0 : waiting to encounter a paragraph
# 1 : reading prop class definition paragraph
# 2 : reading node definition paragraph


  while ( defined($line = <CFILE>)) {
    @words = get_words_list($line);  
    
    #ignore empty or coments or first header ( eASIC props x.y) lines
    if ( !@words || $words[0] eq "#" || $words[0] eq "eASIC" ) {
      next;
    }
    

    if( $STATE == 0 ) { #waiting to enconter a paragraph
	#read number if properties defined
	#example <PropertiesNumber : 3>
	if( $words[0] eq "PropertiesNumber" ){
	    $PROP_SECTION = 0;#first section of the file prop class definition
	    $props_number = $words[2];
	    next;
	}
	
	#prop class definition encountered
	if( $words[0] eq "PropClass" ){
	    #check if the prop class definition is in the right section
	    if( !defined($PROP_SECTION) ){
		print "ERROR : PropertiesNumber should be specified before ";
		print "any PropClass definition\n";
		return 0;
	    }
	    if( $PROP_SECTION == 1 ){
		print "ERROR : PropClass definition in node section\n";
		return 0;
	    }
	    $STATE = 1;
	    $prop_class_name_flag = 0;
	    next;
	}
	
        #node definition encountered
	if( $words[0] eq "Node" ){
	    #check if the node definition is in the right section
	    if( !defined($PROP_SECTION) ){
		print "ERROR : no PropertiesNumber defined ??? ";
		return 0;
	    }
	    if( $PROP_SECTION == 0 ){
		print "ERROR : node definition in PropClass section\n";
		return 0;
	    }
	    $STATE = 2;
	    $node_name_flag = 0;
	    next;
	}

	#end props definition encountered
	if( $words[0] eq "EndProps" ){
	    $PROP_SECTION = 1;
	    #check is the properties number match the props def read
	    if( keys(%prop_class_hash) != $props_number ){
		print "ERROR : mismatch between props defined and number\n";
		return 0;
	    }
	    next;
	}

	#invalid line ??
	print "invalid prop file line %s\n",$line;
        return 0;
    }

    #reading node
    if( $STATE == 2 ){
	
        #end node encountered
	if( $words[0] eq "EndNode" ){
	    $STATE = 0; 
	    $node_name_flag = 0;
	    next;
	}

	if( $words[0] eq "Name"){
	    if($node_name_flag == 1 ){#node name already found
		print "ERROR : node name already found; $line\n";
		return 0;
	    }
	    if( !defined($words[2]) ){
		print "ERROR : prop file node $line doesn't contain the name\n";
		return 0;
	    }
	    if( exists $nodes_hash{$words[2]} ){
		print "ERROR : node $words[2] defined twice\n";
		return 0;
	    }
	    my %temp_props_hash;
	    $nodes_hash{$words[2]} = \%temp_props_hash;
	    $current_node_hash = \%temp_props_hash;
	    $node_name_flag = 1;#set node name found
	    next;
	}

	if( $words[0] eq "Prop"){
	    if( !defined($words[2]) || !defined($words[5]) ){
		print "ERROR : prop file node $line doesn't contain the name\n";
		return 0;
	    }
	    if( exists ${$current_node_hash}{$words[2]} ){
		print "ERROR : prop $words[2] defined twice for this node\n";
		return 0;
	    }
	    
	    #remove "Prop : <name> Value :" from list
	    #only props names remain
	    my $local_node_name = $words[2];
	    my $temp_val = shift @words;
	    $temp_val = shift @words;
	    $temp_val = shift @words;
	    $temp_val = shift @words;
	    $temp_val = shift @words;

	    my @temp_value_list = @words;
	    ${$current_node_hash}{$local_node_name} = \@temp_value_list;
	    next;
	}


	#invalid line ??
	print "invalid prop node file line %s\n",$line;
        return 0;
    }

    #reading prop class definition
    if( $STATE == 1 ){
	
        #end prop class definition encountered
	if( $words[0] eq "EndPropClass" ){
	    $STATE = 0; 
	    $prop_class_name_flag = 0;
	    next;
	}

	if( $words[0] eq "Name"){
	    if($prop_class_name_flag == 1 ){#prop class name already found
		print "ERROR : prop class name already found; $line\n";
		return 0;
	    }
	    if( !defined($words[2]) ){
		print "ERROR : prop file line $line doesn't contain the name\n";
		return 0;
	    }
	    if( exists $prop_class_hash{$words[2]} ){
		print "ERROR : property class $words[2] defined twice\n";
		return 0;
	    }
	    my @value_list;
	    $prop_class_hash{$words[2]} = \@value_list;
	    $current_prop_class = \@value_list;
	    $prop_class_name_flag = 1;#set prop class name found
	    next;
	}

	if( $words[0] eq "Value" ){
	    if( !defined($words[2]) ){
		print "ERROR : prop file line $line doesn't contain the name\n";
		return 0;
	    }
	    if( &is_el_in_list($words[2] , @{$current_prop_class}) == 1 ) {
		print "ERROR : property class $words[2] defined twice\n";
		return 0;
	    } 
	    #add the value o the prop class list
	    push @{$current_prop_class},$words[2]; 
	    next;
	}
	#invalid line ??
	print "invalid prop def file line %s\n",$line;
        return 0;
    }
  }
  close CFILE;
  return 1;
}

####################################
#parse nodes list
#for each of them determine the region,
# check the type and annotate regions structure with color information 
# that will be checked later
####################################
sub process_nodes
{
    my $node_name;
    my $node_props;
    my $node_coords;
    my $node_x;
    my $node_y;

    while ( ($node_name,$node_props) = each %nodes_hash ){
	if( !exists $pl_hash{$node_name} ){
	    eprint "ERROR : placement not found for $node_name node\n";
	    $error_count++;
	    next;
	}
	$node_coords = $pl_hash{$node_name};
	$node_x = ${$node_coords}{"x_coord"};
	$node_y = ${$node_coords}{"y_coord"};

	$legal_site_found = 0;

#	print "$node_name ($node_x $node_y)\n";
	#if( !defined ${$regions_top_inst}{"x_coord"} ){
	#    print "error : undefined top x coord\n";
	#    &my_exit();
	#}

	&annotate_regions( #$regions_top_name,
			   #$regions_top_x,
			   #$regions_top_y,
			   $regions_top_inst,
			   0, 0,
			   $node_x, 
			   $node_y, 
			   $node_props,
	                   $node_name);

	if ($legal_site_found == 0) {
	    eprint "ERROR : $node_name has no legal site found.\n";
	    $error_count++;
	}

    }
}

sub print_regions_levels
{
    my $reg_lev_ref;
    lprint "Begin\n";
    foreach (@region_que) {
	lprint "type : ".${$_}{"level_type"};
	lprint " x coord : ".${$_}{"level_x"};
	lprint " y coord : ".${$_}{"level_y"}." =>\n";
    }
    lprint "End.\n";
}

####################################
#annotate regions with colors
#check type of the node for leaf regions
####################################
sub annotate_regions
{
    #my ($pa_name, $pa_x, $pa_y, $node_x, $node_y, $node_props, $nod_name) = @_;

    my ($pa_inst, $rel_x, $rel_y, $node_x, $node_y, $node_props, $nod_name) = @_;
    my $pa_name = ${$pa_inst}{"type"};
    my $pa_x = ${$pa_inst}{"x_coord"} + $rel_x;
    my $pa_y = ${$pa_inst}{"y_coord"} + $rel_y;

#    if( !defined $pa_x ){
#	print "ERROR undefined coord x for PropArea $pa_name\n";
#	&my_exit();
#    }
    
    my %temp_reg_level = ( "level_type" => $pa_name,
			   "level_x" => $pa_x,
			   "level_y" => $pa_y);
    push @region_que , \%temp_reg_level;

    my $temp_reg_hash = $regions_hash{$pa_name};
    if( !defined ${$temp_reg_hash}{"width"} ||
	!defined ${$temp_reg_hash}{"height"} ){ #should be set by now
	print "ERROR : sw 0001 assert\n";
	&my_exit();
    }
    my ($pa_w, $pa_h) = (${$temp_reg_hash}{"width"}, 
			 ${$temp_reg_hash}{"height"});

#    print "node: $node_x , $node_y    pa: $pa_name ($pa_x ,$pa_y), ($pa_w, $pa_h)\n";
    #check if the node is outside prop aprea boundary
    # because region files were published with non-integers, this 
    # check needs to round (liberally) to allow integer components 
    # to be placed legally.

    if( $node_x < int($pa_x) ||
	$node_x >= int($pa_x + $pa_w + 0.5) ||
	$node_y < int($pa_y) ||
	$node_y >= int($pa_y + $pa_h +0.5) ){
	#error ? shoudn't get here... top level mismatch ?
#	print "POP : node doesn't belong to $pa_name region\n";
	pop @region_que;
	return 1;
    }

#    print "$nod_name contain by $pa_name\n";
#    &dump_region_inst($pa_inst);

    my $temp_reg_property;
    my $pa_reg_props;


    while ( ($l_prop_name,$l_props) = each  %{$node_props} ){
	$pa_reg_props = ${$temp_reg_hash}{"props"};
	if( exists ${$pa_reg_props}{$l_prop_name}){
	    $temp_reg_property = ${$pa_reg_props}{$l_prop_name};
	    
	    #check is the regions prop is a type one 
	    if( ${$temp_reg_property}{"type"} eq "Values" ){
		#if yes that check if the type of the node matches
		#   the type of the region
		# most probably this region is a leaf
		if( ! (${$temp_reg_property}{"val"} eq ${$l_props}[0]) ){
		    eprint "ERROR : type <".${$l_props}[0]."> of node ".
			$nod_name." doesn't match with type <".
			${$temp_reg_property}{"val"}."> of region :\n";
		    $error_count++;
		    print_regions_levels;
		}
		else {
		    $legal_site_found = 1;
		}
		    
		next;
	    }
	    
	    #property of type colors number
	    my $prop_value;
	    foreach $prop_value ( @{$l_props} ) {
		#copy last node name and it's prop value
		#my $annotate_list_ref = ${$temp_reg_property}{"annotate_list"};
		my $annotate_list_ref = ${$pa_inst}{"annotate_list"};
		my %temp_a_hash;
		if( !exists ${$annotate_list_ref}{$l_prop_name} ){
		    ${$annotate_list_ref}{$l_prop_name} = \%temp_a_hash;
		}
		my $annotate_prop_ref = ${$annotate_list_ref}{$l_prop_name};
		if (!defined $annotate_prop_ref) { 
		    print "undef hash assert sw 00003\n";
		    &my_exit();
		}
		#push @{$annotate_list_ref}, $prop_value;
		${$annotate_prop_ref}{$prop_value} = $nod_name;
	    }
	}
    }


    #my @pa_insts = @{${$temp_reg_hash}{"insts"}};
    #my $pa_inst;
    #foreach $pa_inst (@pa_insts) {
    
#%unique_regions_hash
	
    if( !exists $unique_regions_hash{${$pa_inst}{"master_id"}} ){
	print "sw assert 00004\n";
	&my_exit();
    }
    
    foreach  (@{$unique_regions_hash{${$pa_inst}{"master_id"}}}) {
	#call annotate function for all the instances of this region
	&annotate_regions( #${$pa_inst}{"type"},
			   #${$pa_inst}{"x_coord"},
			   #${$pa_inst}{"y_coord"},
			   $_,
			   $pa_x,
			   $pa_y,
			   $node_x, 
			   $node_y,
			   $node_props,
	                   $nod_name);    
    
    }

    pop @region_que;
    return 1;
	
}


####################################
#
# 
####################################
sub uniquefy_regions_areas
{
    my $pa_inst = $_[0];

    my $pa_level_name = ${$pa_inst}{"type"};
    if( !exists $regions_hash{$pa_level_name} ){
	print "ERROR : computing checking : level $pa_level_name not found\n";
	&my_exit();
    }
    my $temp_reg_hash = $regions_hash{$pa_level_name};

    #copy masters inst list for this instance
    if ( exists $unique_regions_hash{$unique_regions_id} ){
	eprint "ERROR : sw assert 0002\n";
	&my_exit();
    }

    #copy/dupplicate list elements( hash refs )
    my @unique_inst_list;
    my $unique_inst_list_ref = ${$temp_reg_hash}{"insts"};
    foreach (@{$unique_inst_list_ref}) {
	my %temp_copy_hash = %{$_};#copy hash
	my %temp_a_hash;
	#add new annotate list ref
	$temp_copy_hash{"annotate_list"} = \%temp_a_hash;
	push @unique_inst_list , \%temp_copy_hash;
    }
    $unique_regions_hash{$unique_regions_id} = \@unique_inst_list;

    ${$pa_inst}{"master_id"} = $unique_regions_id;
    my $temp_unique_id = $unique_regions_id;
    $unique_regions_id++;
    
    foreach  ( @{$unique_regions_hash{$temp_unique_id}} ) {
	&uniquefy_regions_areas($_);
    }

    return 1;
}


####################################
#check regions for color type properties
# to see if the actual number of colors doesn't exceed the regions 
####################################
sub check_design_colors_number
{
    my $pa_inst = $_[0];

    #eprint "type ".${$pa_inst}{"type"}." x:y ".
#	${$pa_inst}{"x_coord"}.":".${$pa_inst}{"y_coord"}."\n";

    my $pa_level_name = ${$pa_inst}{"type"};
    if( !exists $regions_hash{$pa_level_name} ){
	print "ERROR : computing checking : level $pa_level_name not found\n";
	&my_exit();
    }
    my $temp_reg_hash = $regions_hash{$pa_level_name};
    #my $temp_reg_props_hash =  $temp_reg_hash{"props"};
    
    while( ($d_prop_name,$d_prop_hash) = each %{${$temp_reg_hash}{"props"}} ){
	
	#check only NumColors type properties
	unless ( ${$d_prop_hash}{"type"} eq "NumColors" ) { next; }
	
	#check if the property exists on inst
	unless ( exists ${$pa_inst}{"annotate_list"}) { next; }
	my $temp_ann_hash = ${$pa_inst}{"annotate_list"};
	unless ( exists ${$temp_ann_hash}{$d_prop_name}) { next; }
	my $temp_prop_hash = ${$temp_ann_hash}{$d_prop_name};
	
	#check if the max color number accepteb by the region is not
	# exceeded by the colors defined per this instance
	if( ${$d_prop_hash}{"val"} < keys %{$temp_prop_hash} ){
	    my @print_colors = %{$temp_prop_hash};
	    eprint "ERROR : mismatch between num colors allowed ".
		 ${$d_prop_hash}{"val"}." on the $pa_level_name type of ".
		 "region, instance coord x ".${$pa_inst}{"x_coord"}.
		 " coord y ".${$pa_inst}{"y_coord"}.
		 " and num colors found : ".scalar keys (%{$temp_prop_hash}) .
		 " eg : @print_colors\n";
	    $error_count++;
	}
	
    }

    if( !exists $unique_regions_hash{${$pa_inst}{"master_id"}} ){
	print "sw assert 00005\n";
	&my_exit();
    }
    
    foreach  (@{$unique_regions_hash{${$pa_inst}{"master_id"}}}) {
    #foreach  ( @{${$temp_reg_hash}{"insts"}} ) {
	&check_design_colors_number($_);
    }

    return 1;
}

####################################
# compute bbox for non leaf reagions
# usage compute_reagions_bbox top_proparea_name
# return bbox width and height ( in this order )
####################################
sub compute_reagions_bbox
{

    my $pa_level_name = $_[0];
    #print "computing bbox for $pa_level_name\n";
    if( !exists $regions_hash{$pa_level_name} ){
	print "ERROR : computing bbox : level $pa_level_name not found\n";
	$error_count++;
	&my_exit();
    }
    my %temp_reg_hash = %{$regions_hash{$pa_level_name}};
    if( defined $temp_reg_hash{"width"} ){#leaf prop area level
	return ( $temp_reg_hash{"width"}, $temp_reg_hash{"height"} );
    }

    #debug only
    #lprint "computing bbox for $pa_level_name\n";

    #non leaf level => parse insts to compute bbox
    my @temp_reg_inst = @{$temp_reg_hash{"insts"}};
    if( $#temp_reg_inst == -1){#test if the list is empty
	print "ERROR: computing : non leaf level $pa_level_name has no insts\n";
	$error_count++;
	&my_exit();
    }

    my $temp_width;
    my $temp_height;
    my $temp_inst_type;

    my $inst_maxX;
    my $inst_maxY;

    my $level_minX;
    my $level_minY;
    my $level_maxX;
    my $level_maxY;

    foreach $pa_instance ( @temp_reg_inst ) {
	$temp_inst_type = ${$pa_instance}{"type"};
	($temp_width, $temp_height) = &compute_reagions_bbox($temp_inst_type);

	if(!defined(${$pa_instance}{"x_coord"}) ||
	   !defined(${$pa_instance}{"y_coord"})){
	    print "ERROR : instance with no x or y coords defined\n";
	    $error_count++;
	    &my_exit();
	}
	$inst_maxX = ${$pa_instance}{"x_coord"} + $temp_width;
	$inst_maxY = ${$pa_instance}{"y_coord"} + $temp_height;
    
	$level_minX = &my_min($level_minX,${$pa_instance}{"x_coord"});
	$level_minY = &my_min($level_minY,${$pa_instance}{"y_coord"});
	$level_maxX = &my_max($level_maxX,$inst_maxX);
	$level_maxY = &my_max($level_maxY,$inst_maxY);
	
    }
    
    my $w = $level_maxX-$level_minX;
    my $h = $level_maxY-$level_minY;
    #debug print
    #lprint "for $pa_level_name found w $w ; h $h \n";
    ${$regions_hash{$pa_level_name}}{"width"} = $level_maxX-$level_minX;
    ${$regions_hash{$pa_level_name}}{"height"} = $level_maxY-$level_minY;
    return ($level_maxX-$level_minX, $level_maxY-$level_minY);
}

sub my_min 
{
    ( $a, $b ) = @_;
    if( !defined $a ) { return $b; };
    if( $a < $b ) { return $a; }
    return $b;
}

sub my_max 
{
    ( $a, $b ) = @_;
    if( !defined $a ) { return $b; };
    if( $a > $b ) { return $a; }
    return $b;
}

sub dump_region_inst
{
    my $inst_ref = $_[0];

    my $d_temp;
    $d_temp = ${$inst_ref}{"type"};
    eprint "TYPE : <$d_temp> ";
    $d_temp = ${$inst_ref}{"x_coord"};
    eprint "X : <$d_temp> ";
    $d_temp = ${$inst_ref}{"y_coord"};
    if( !defined $d_temp ) { $d_temp = "undef"; }
    eprint "Y : <$d_temp> \n";
    $d_temp = ${$inst_ref}{"annotate_list"};
    if( !defined $d_temp ) { 
	eprint "ANNOTATION LIST : empty\n";
	return;
    }
    
    my ($d_prop_name,$d_prop_hash);
    eprint "ANNOTATION LIST\n";
    while( ($d_prop_name,$d_prop_hash) = each %{$d_temp}){
	my @d_prop_list = %{$d_prop_hash};
	eprint " PROPERTY NAME <$d_prop_name> VALUES PAIRS <@d_prop_list>\n";
    }
}

sub dump_hierarhical_insts
{
    my $pa_inst = $_[0];
    &dump_region_inst($pa_inst);
    if( !exists $unique_regions_hash{${$pa_inst}{"master_id"}} ){
	print "sw assert 00006\n";
	&my_exit();
    }
    
    foreach  (@{$unique_regions_hash{${$pa_inst}{"master_id"}}}) {
	&dump_hierarhical_insts($_);
    }
}

sub dump_regions_db
{

    eprint "\nPRINTING INSTAS HIERARCHY\n";

    if( !defined $regions_top_inst ){
	eprint "ERROR : top module inst not defined\n";
	    $error_count++;
	&my_exit();
    }
    &dump_hierarhical_insts($regions_top_inst);
    #if( !exists $unique_regions_hash{${pa_inst}{"master_id"}} ){
#	print "sw assert 00004\n";
#	&my_exit();
#    }  
#    foreach  (@{$unique_regions_hash{${pa_inst}{"master_id"}}}) {


    eprint "\nPRINTING REGIONS\n";
    my $d_reg_type;
    my $d_reg_hash;
    my $d_prop_name;
    my $d_prop_hash;
    while ( ($d_reg_type,$d_reg_hash) = each %regions_hash ){
	eprint "\n\nREGION LEVEL <$d_reg_type>\n";
	my $d_temp = ${$d_reg_hash}{"width"};
	if( !defined $d_temp ) { $d_temp = "undef"; }
	eprint "WIDTH <$d_temp>\n";
	$d_temp = ${$d_reg_hash}{"height"};
	if( !defined $d_temp ) { $d_temp = "undef"; }
	eprint "HEIGHT <$d_temp>\n";
	eprint "PROPS LIST :\n";
	my %d_reg_prop_hash =  %{${$d_reg_hash}{"props"}};
	while ( ($d_prop_name,$d_prop_hash) = each %d_reg_prop_hash ){
	    eprint "PROPERTY NAME <$d_prop_name>\n";
	    $d_temp = ${$d_prop_hash}{"type"};
	    if( !defined $d_temp ) { $d_temp = "undef"; }
	    eprint "PROPERTY TYPE <$d_temp>\n";
	    $d_temp = ${$d_prop_hash}{"val"};
	    if( !defined $d_temp ) { $d_temp = "undef"; }
	    eprint "PROPERTY VALUE <$d_temp>\n";
	    #my @d_annotate_list = %{${$d_prop_hash}{"annotate_list"}};
	    #eprint "PROPERTY_ANNOTATIO_LIST : @d_annotate_list\n";
	}
	eprint "REGION INSTS :\n";
	my $temp_ = ${$d_reg_hash}{"insts"};
	my @d_reg_insts = @{${$d_reg_hash}{"insts"}};
	my $d_reg_inst;
	foreach $d_reg_inst (@d_reg_insts) {
	    &dump_region_inst($d_reg_inst);
	    #d_temp = ${$d_reg_inst}{"type"};
	    #print "TYPE : <$d_temp> ";
	    #d_temp = ${$d_reg_inst}{"x_coord"};
	    #print "X : <$d_temp> ";
	    #d_temp = ${$d_reg_inst}{"y_coord"};
	    #f( !defined $d_temp ) { $d_temp = "undef"; }
	    #print "Y : <$d_temp> \n";
	}
    }
}

####################################
# process regions file
# return 0 if errors occured; 1 if OK
####################################
sub process_regions_file
{

  unless ( open (CFILE, "<$regions_file_name") ) {
    print       "unable to open $regions_file_name file\n";
    print EFILE "unable to open $regions_file_name file\n";
    return 0;
  }

  my $line;
  my @words;
  my $STATE = 0;
# possible states 
# 0 : waiting to encounter a paragraph
# 1 : reading PropArea definition paragraph
# 2 : reading node definition paragraph


  while ( defined($line = <CFILE>)) {
    @words = get_words_list($line);  
    
    #ignore empty or coments or first header ( eASIC props x.y) lines
    if ( !@words || $words[0] eq "#" || $words[0] eq "eASIC" ) {
      next;
    }

    if( $STATE == 0 ){

	#the instantiation of the top module found
	if( $words[0] eq "PropAreaInst" ) {
	    #check if other top module instatntiation were found
	    #if( defined $regions_top_name ){
	    if( defined $regions_top_inst ){
		print "ERROR : duplicated top module instatiation\n";
		return 0;
	    } 
	    if (!defined($words[2])||!defined($words[4])||!defined($words[6])){
		print "ERROR : invalid top module instantiation $line\n";
		return 0;
	    }

	    my %temp_a_hash;
	    my %temp_prop_area_inst = (
		"type" => $words[2],
		"x_coord" => $words[4],
		"y_coord" => $words[6],
		"annotate_list" => \%temp_a_hash);
	    $regions_top_inst = \%temp_prop_area_inst;
	    #$regions_top_name = $words[2];
	    #$regions_top_x = $words[4];
	    #$regions_top_y = $words[6];
	    next;
	}

	#PropArea definition found
	if( $words[0] eq "PropArea" ){
	    $STATE = 1;
	    next;
	}
	#invalid line ??
	print "ERROR : invalid line $line\n";
	return 0;
    }
    
    if( $STATE == 1 ){#prop area definition 
	
	#name of the prop area : should be first statement in a PropArea def
	if( $words[0] eq "Name" ){
	    
	    if( !defined $words[2] ){
		print "ERROR : invalid PropArea Name statement $line\n";
		return 0;	    }

	    #check for duplicate prop area name
	    if( exists $regions_hash{$words[2]} ){
		print "ERROR : PropArea $words[0] already defined\n";
		return 0;
	    }

	    my @tmp_reg_insts;
	    my %temp_reg_props;
	    my %temp_reg_hash = (
	             "width" => undef,
	             "height" => undef,
	             "props" => \%temp_reg_props,
	             "insts" => \@tmp_reg_insts );
	    $regions_hash{$words[2]} = \%temp_reg_hash;
	    $current_regions_hash = \%temp_reg_hash;
	    next;
	}
	
	#Width 
	if( $words[0] eq "Width" ){
	    if( !defined $words[2] ){
		print "ERROR : invalid width statement $line\n";
		return 0;
	    }
	    if( defined ${$current_regions_hash}{"width"} ){
		print "ERROR : width defined twice for this PropArea\n";
		return 0;
	    }
	    ${$current_regions_hash}{"width"} = $words[2];
	    next;
	}
	

	#Height 
	if( $words[0] eq "Height" ){
	    if( !defined $words[2] ){
		print "ERROR : invalid height statement $line\n";
		return 0;
	    }
	    if( defined ${$current_regions_hash}{"height"} ){
		print "ERROR : height defined twice for this PropArea\n";
		return 0;
	    }
	    ${$current_regions_hash}{"height"} = $words[2];
	    next;
	}

	#PropAreaInst
	if( $words[0] eq "PropAreaInst" ){
	    if(!defined($words[2]) || 
	       !defined($words[4]) || 
	       !defined($words[6]) ){
		print "ERROR : Invalid PropAreaInst def line : $line\n";
		return 0;
	    }
	    
	    #my %temp_a_hash;
	    my %temp_prop_area_inst = (
		"type" => $words[2],
		"x_coord" => $words[4],
		"y_coord" => $words[6]);#,
		#"annotate_list" => \%temp_a_hash);
	    push @{${$current_regions_hash}{"insts"}}, \%temp_prop_area_inst;
	    next;
	}

	#Property
	if( $words[0] eq "Property" ){
	    if(!defined($words[2]) || 
	       !defined($words[3]) || 
	       !defined($words[5]) ){
		print "ERROR : Invalid Property def line : $line\n";
		return 0;
	    }
	    
	    #check if the property type is correct 
	    if(! ( $words[3] eq "Values" ||
		   $words[3] eq "NumColors" ) ){
		print "ERROR : Invalid Property def line : $line\n";
		return 0;
	    }

	    #check if the property was already defined
	    if( exists ${${$current_regions_hash}{"props"}}{$words[2]} ){
		print "ERROR : property $words[2] already defined\n";
		return 0;
	    }
	    
	    #my %temp_a_hash;
	    my %temp_property = ( "type" => $words[3],
				  "val" => $words[5]);#,
	                          #"annotate_list" => \%temp_a_hash );
	    my $temp_hash_ref = ${$current_regions_hash}{"props"};
	    if( !defined $temp_hash_ref ) {
		print "HASH REF NOT DEFINED\n";
		&my_exit();
	    }
	    #${${$current_regions_hash}{"props"}}{$words[2]} = \%temp_property;
	    ${$temp_hash_ref}{$words[2]} = \%temp_property;
	    next;
	}

	#Property end
	if( $words[0] eq "EndPropArea" ){
	    $STATE = 0;
	    next;
	}
	#invalid line ??
	print "ERROR : invalid PropArea def line <$line>\n";
	return 0;
    }
  }
  close CFILE;
  return 1;
}



#########################################
# prints usage message
#########################################
sub print_usage
{
    print "USAGE : regions_legality_check.pl -props <prop file name>\n";
    print "                                  -regions <regions file name>\n";
    print "                                  -pl <pl file name>\n"; 
}

##########################################
# process text file input line
# return list of words 
##########################################
sub get_words_list
{
chomp ( my $line = $_[0] );

  $line =~ s/^\s+//; # removes front/end white spaces
  $line =~ s/\s+$//;
  return split(/\s+/, $line);   
}           

##########################################
# exit routine
##########################################
sub my_exit
{
  print		"Abnormal condition happened. Exit\n";
  print EFILE	"Abnormal condition happened. Exit\n";
  exit(1);
}

#########################################
# is element in list
# if true return 1
# if not exist return 0
# usage : $flag = &is_el_in_list($element, @list)
#########################################
sub is_el_in_list
{
    my $searched_element = shift @_;
    foreach( @_ ) {
	if( $searched_element eq $_ ){
	    return 1;#found
	}
    }
    return 0;#not found
}
